/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.tools.crawler.postprocessing.logcat;

import androidx.test.tools.crawler.postprocessing.logcat.LogcatFinding;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Duration;
import com.google.protobuf.util.Durations;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class LogcatFilter {
    private static final ImmutableList<String> GENERAL_CRASH_WHITELIST = ImmutableList.of("/system/bin/dex2oat", "/system/vendor/bin/gsiff_daemon", "is package not installed?");
    private static final ImmutableList<String> ROBO_CRASH_WHITELIST = ImmutableList.of("com.google.maps", "android.gms.maps");
    private static final Pattern WHITELISTED_NON_SDK_API_USERS = Pattern.compile("androidx\\.test\\.espresso\\.|androidx\\.test\\.tools\\.crawler\\.obfuscated\\.");

    @VisibleForTesting
    public static List<LogcatFinding> filterLogcatFindings(List<LogcatFinding> logcatFindings, String appPackageName, String deviceVersionId) {
        Optional<LogcatFinding> roboTestFinished = logcatFindings.stream().filter(finding -> finding.type() == LogcatFinding.LogcatFindingType.ROBO_TEST_COMPLETED).findAny();
        Optional<LogcatFinding> fatalException = logcatFindings.stream().filter(finding -> finding.type() == LogcatFinding.LogcatFindingType.FATAL_EXCEPTION).findAny();
        List appPids = logcatFindings.stream().filter(LogcatFilter.isStartAppProcFinding(appPackageName)).mapToInt(finding -> finding.pid()).boxed().collect(Collectors.toList());
        logcatFindings = logcatFindings.stream().filter(finding -> !roboTestFinished.isPresent() || finding.timestamp().isBefore(((LogcatFinding)roboTestFinished.get()).timestamp())).filter(LogcatFilter.appStartTimeForSomeOtherApp(appPackageName).negate()).filter(LogcatFilter.untrustedAppStartTime(deviceVersionId).negate()).filter(finding -> LogcatFilter.crashNotInWhitelist(finding, GENERAL_CRASH_WHITELIST)).filter(finding -> !fatalException.isPresent() || finding.type() != LogcatFinding.LogcatFindingType.MONITORING_INSTR_EXCEPTION).filter(finding -> finding.type() != LogcatFinding.LogcatFindingType.NON_SDK_API_USED || appPids.contains(finding.pid())).filter(finding -> finding.type() != LogcatFinding.LogcatFindingType.NON_SDK_API_USED || !LogcatFilter.isWhitelistedNonSdkApiUsage(finding)).filter(finding -> !roboTestFinished.isPresent() || LogcatFilter.crashNotInWhitelist(finding, ROBO_CRASH_WHITELIST)).collect(Collectors.toList());
        return logcatFindings;
    }

    private static Predicate<LogcatFinding> isStartAppProcFinding(String appPackageName) {
        return finding -> {
            if (finding.type() != LogcatFinding.LogcatFindingType.START_PROC) {
                return false;
            }
            return finding.packageName().get().equals(appPackageName);
        };
    }

    private static Predicate<LogcatFinding> appStartTimeForSomeOtherApp(String appPackageName) {
        return finding -> (finding.type() == LogcatFinding.LogcatFindingType.STARTUP_TIME_DEFAULT || finding.type() == LogcatFinding.LogcatFindingType.STARTUP_TIME_FULLY_DRAWN) && !finding.message().contains(appPackageName);
    }

    private static Predicate<LogcatFinding> untrustedAppStartTime(String deviceVersionId) {
        return finding -> (finding.type() == LogcatFinding.LogcatFindingType.STARTUP_TIME_DEFAULT || finding.type() == LogcatFinding.LogcatFindingType.STARTUP_TIME_FULLY_DRAWN) && deviceVersionId.equals("26") && LogcatFilter.getStartupDuration(finding).getSeconds() > 5L;
    }

    public static boolean causedByAppUnderTest(LogcatFinding finding, String appPackageName) {
        if (finding.packageName().or("").equals(appPackageName) || finding.stacktrace().or("").contains(appPackageName)) {
            return true;
        }
        return finding.type() == LogcatFinding.LogcatFindingType.MONITORING_INSTR_EXCEPTION;
    }

    private static boolean crashNotInWhitelist(LogcatFinding logcatFinding, ImmutableList<String> whitelistedCrashCauses) {
        for (String cause : whitelistedCrashCauses) {
            if (!logcatFinding.message().contains(cause) && !logcatFinding.stacktrace().or("").contains(cause)) continue;
            return false;
        }
        return true;
    }

    private static boolean isWhitelistedNonSdkApiUsage(LogcatFinding finding) {
        return finding.nonSdkApiCaller().isPresent() && WHITELISTED_NON_SDK_API_USERS.matcher(finding.nonSdkApiCaller().get()).find();
    }

    public static Duration getStartupDuration(LogcatFinding firstDefaultFinding) {
        return Durations.fromMillis(firstDefaultFinding.startupTime().get().getMillis());
    }
}

