/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.tools.crawler.launcher.setup;

import androidx.test.tools.crawler.common.base.Logger;
import androidx.test.tools.crawler.launcher.exceptions.CrawlSetupException;
import androidx.test.tools.crawler.launcher.setup.CrawlSetup;
import com.google.common.base.Strings;
import com.google.common.collect.Ordering;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;

public class ExternalCrawlSetup
extends CrawlSetup {
    private static final String ANDROID_SDK_FLAG = "--android-sdk";
    private static final String KEY_STORE_FLAG = "--key-store";
    private static final String KEY_STORE_PASSWORD_FLAG = "--key-store-password";
    private String runningJarPath = "";
    private String androidSdkPath = "";
    private File platformToolsDir;
    private File buildToolsDir;
    private String androidJarPath;
    private String keyStorePath = "";
    private String keyStorePassword = "";

    @Override
    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    @Override
    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    @Override
    protected void processModeSpecificCrawlParameters(String[] crawlParameters) {
        try {
            this.runningJarPath = new File(ExternalCrawlSetup.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getAbsolutePath();
        }
        catch (Exception e) {
            throw new CrawlSetupException("Failed to establish the location of the running jar.", e);
        }
        Logger.atDebug().log("runningJarPath: %s", this.runningJarPath);
        for (int i = 0; i < crawlParameters.length; ++i) {
            String crawlParameter = crawlParameters[i];
            if (ANDROID_SDK_FLAG.equals(crawlParameter)) {
                this.androidSdkPath = crawlParameters[++i];
                continue;
            }
            if (KEY_STORE_FLAG.equals(crawlParameter)) {
                this.keyStorePath = crawlParameters[++i];
                continue;
            }
            if (!KEY_STORE_PASSWORD_FLAG.equals(crawlParameter)) continue;
            this.keyStorePassword = crawlParameters[++i];
        }
        if (this.androidSdkPath.isEmpty()) {
            throw new CrawlSetupException("Please provide Android SDK path");
        }
        if (!this.keyStorePath.isEmpty() && this.keyStorePassword.isEmpty()) {
            throw new CrawlSetupException("Please provide key store password for the key store " + this.keyStorePath);
        }
        this.androidSdkPath = this.checkFileExistsAndNormalizeIfSpecified(this.androidSdkPath, "Android SDK", false);
        if (this.keyStorePath.isEmpty()) {
            this.keyStorePath = Paths.get(this.runningJarPath, new String[0]).resolveSibling("debug.keystore").toAbsolutePath().toString();
            this.keyStorePassword = "android";
        } else {
            this.keyStorePath = this.checkFileExistsAndNormalizeIfSpecified(this.keyStorePath, "key store", true);
        }
        this.platformToolsDir = new File(this.androidSdkPath + "/platform-tools");
        this.initializeWithLatestBuildToolsAndAndroidJar();
    }

    private void initializeWithLatestBuildToolsAndAndroidJar() {
        try {
            File buildTools = new File(this.androidSdkPath, "build-tools");
            this.buildToolsDir = new File(buildTools, this.findAlphabeticallyLargestChild(buildTools));
        }
        catch (Exception e) {
            throw new CrawlSetupException("Failed to initialize build tools location for Android SDK " + this.androidSdkPath, e);
        }
        try {
            File platforms = new File(this.androidSdkPath, "platforms");
            File androidJarFile = new File(new File(platforms, this.findAlphabeticallyLargestChild(platforms)), "android.jar");
            this.androidJarPath = androidJarFile.getAbsolutePath();
            if (!androidJarFile.exists()) {
                throw new CrawlSetupException("Failed to find android.jar in the expected location " + this.androidJarPath);
            }
        }
        catch (Exception e) {
            throw new CrawlSetupException("Failed to initialize android.jar location for Android SDK " + this.androidSdkPath, e);
        }
        Logger.atDebug().log("buildToolsDir: %s", this.buildToolsDir);
        Logger.atDebug().log("androidJarPath: %s", this.androidJarPath);
    }

    private String findAlphabeticallyLargestChild(File parent) {
        return Ordering.from((s1, s2) -> {
            if (!Strings.isNullOrEmpty(s1) && !Character.isDigit(s1.charAt(0))) {
                s1 = "!" + s1;
            }
            if (!Strings.isNullOrEmpty(s2) && !Character.isDigit(s2.charAt(0))) {
                s2 = "!" + s2;
            }
            return s1.compareTo((String)s2);
        }).max(Arrays.asList(parent.list()));
    }

    @Override
    protected Path getDefaultOutputDirectoryPath() {
        return Paths.get(this.getApkFilePath(), new String[0]).resolveSibling("crawl_output");
    }

    @Override
    public void buildCrawler() {
    }

    @Override
    public Path getCrawlerAppApkPath() {
        return Paths.get(this.runningJarPath, new String[0]).resolveSibling("crawler_app.apk");
    }

    @Override
    public File getCrawlerStubappApk() {
        return new File(new File(this.runningJarPath).getParentFile(), "crawler_stubapp_androidx.apk");
    }

    @Override
    public String getAndroidJarPath() {
        return this.androidJarPath;
    }

    @Override
    public Optional<File> getVideocatBinary(int deviceApiLevel) {
        return Optional.empty();
    }

    @Override
    public void postprocessVideocat(Path rawVideocatOutputPath, String appPackageName) {
    }

    @Override
    public File getExecutable(CrawlSetup.ExecutableType executableType) {
        boolean isWindows = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("win");
        switch (executableType) {
            case AAPT: {
                return new File(this.buildToolsDir, isWindows ? "aapt2.exe" : "aapt2");
            }
            case ADB: {
                return new File(this.platformToolsDir, isWindows ? "adb.exe" : "adb");
            }
            case ZIPALIGN: {
                return new File(this.buildToolsDir, isWindows ? "zipalign.exe" : "zipalign");
            }
        }
        throw new CrawlSetupException("Unsupported executable type " + (Object)((Object)executableType));
    }

    @Override
    public Optional<Path> getSignaturesFilePath() {
        return Optional.empty();
    }

    @Override
    public String getCrawlDriverInitializerClass() {
        return "androidx.test.tools.crawler.CrawlDriverDaggerInitializerImpl";
    }
}

